IF EXISTS
(
    SELECT *
    FROM sys.objects
    WHERE object_id = OBJECT_ID(N'[dbo].[UFD_RET_QTDE_PED_INTEGRADO]')
          AND type IN(N'FN', N'IF', N'TF', N'FS', N'FT')
)
BEGIN
	DROP FUNCTION [dbo].[UFD_RET_QTDE_PED_INTEGRADO];
END
GO
	/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20230816
'Job.................:  
'Nome................:  UFD_RET_QTDE_PED_INTEGRADO
'Objetivo............: 
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 2023-08-16
'Alterado por........: Jerfeson Babrosa
'Criado por..........: 
'=======================================================================================
FARMAGOI-43112 - Adicionado no parmetro @TIPO nas linhas 114 e 127 o tipo 3. 
OBS: Alterado por Ramam na linha 54 a condio @TIPO <> 3
*/

CREATE FUNCTION [dbo].[UFD_RET_QTDE_PED_INTEGRADO]( @QT_FACEAMENTO MONEY, 
													@QT_FINANCIAMENTO MONEY, 
													@QT_LIMITADOR MONEY, 
													@EMAX MONEY, 
													@ESEG MONEY,
													@PARAM MONEY,
													@MEDIAF MONEY,
													@QT_EST MONEY,
													@TIPO   INT=NULL) 
														--@TIPO =0 EXCESSO E NECESSIDADE
														--@TIPO =1 EXCESSO  
														--@TIPO =2 NECESSIDADE
														--@TIPO =3 EXCESSO SEM LIMITADOR
RETURNS MONEY with schemabinding AS 
BEGIN
	DECLARE @FINAL			MONEY,
			@EST_CALC		MONEY,
			@QT_INTEGRADO	MONEY,
			@Necessidade	money,
			@Excesso		money;
/**********************************************************************************************************/
	IF @TIPO = NULL
		SET @TIPO = 0;	


	if @MEDIAF> 0 and @TIPO <> 3
		begin
			SET @EST_CALC = Round((((@MEDIAF/ 30.000000))) * (@PARAM + @EMAX), 0);
		end
	else
		begin
			SET @EST_CALC = @QT_EST
		end 
		 

	SET @EMAX =  @MEDIAF/30.000000 * @EMAX ;
	SET @ESEG = @MEDIAF/30.000000 * @ESEG ;	
	
	SET @EMAX =  round(@EMAX ,0 );
	SET @ESEG = round(@ESEG ,0 ); 
	SET @FINAL = @EMAX	 

	IF (@QT_FACEAMENTO > @FINAL)
	begin
		SET @FINAL = @QT_FACEAMENTO;
	end
	
	IF @QT_FINANCIAMENTO > @FINAL 	
	begin
		SET @FINAL = @QT_FINANCIAMENTO;
	end 


	IF @QT_LIMITADOR > 0 
		BEGIN
			IF @QT_LIMITADOR < @FINAL 
				BEGIN
					SET @FINAL = @QT_LIMITADOR
				END
		END

	SET @QT_INTEGRADO = 0;


--Verifica se ha ponto de ressuprimento
If @QT_FACEAMENTO > @ESEG SET @ESEG = @QT_FACEAMENTO;
If @QT_FINANCIAMENTO > @ESEG 
	SET @ESEG =  @QT_FINANCIAMENTO;

/**********************************************************************************************************/
    Set @Necessidade= 0;
	Set @Excesso= 0;

----------------------------------------------------------
--NECESSIDADE
	
IF @TIPO in (2,0,3) 
	BEGIN
		Set @Necessidade = @Final-@Qt_Est
		IF  (@QT_EST>=@ESEG AND  @QT_EST > @FINAL and @ESEG > 0 ) Or @Necessidade<0
			Set @Necessidade= 0;
		if @Necessidade<0
			Set @Necessidade=0;
	end
----------------------------------------------------------
--EXCESSO  
	IF @TIPO in (1,0,3) 
	BEGIN
		If @QT_EST > @EST_CALC AND @QT_EST > @FINAL
			SET @QT_EST = @EST_CALC
		Set @Excesso = @Final - @Qt_Est	
		if @Excesso > 0
			Set @Excesso=0;
	END 

----------------------------------------------------------	

	SET @QT_INTEGRADO = @Necessidade + @Excesso;

	IF @TIPO IN (1,3)
		IF @QT_INTEGRADO > 0 
			SET @QT_INTEGRADO = 0;

	IF @TIPO =2
		IF @QT_INTEGRADO < 0 
			SET @QT_INTEGRADO =0;


	RETURN @QT_INTEGRADO;
END 


